<?php 
/**
 * Recursively escape API response data for output.
 *
 * @param mixed $data The data to escape
 * @return mixed The escaped data
 */
function wprentals_escape_api_response($data) {
    if (is_array($data)) {
        foreach ($data as $key => $value) {
            $data[$key] = wpresidence_escape_api_response($value);
        }
        return $data;
    } else if (is_object($data)) {
        foreach (get_object_vars($data) as $key => $value) {
            $data->$key = wpresidence_escape_api_response($value);
        }
        return $data;
    } else if (is_string($data)) {
        // Handle different data types appropriately
        if (filter_var($data, FILTER_VALIDATE_URL)) {
            return esc_url($data);
        } else if (preg_match('/<[^>]*>/', $data)) {
            // Contains HTML
            return wp_kses_post($data);
        } else {
            return esc_html($data);
        }
    } else {
        // Return non-string values as is (numbers, booleans, etc.)
        return $data;
    }
}